/* seqmoddiv.v
 *
 * sequential mod / div module
 *
 * (see moddiv.v)
 *
 * Luis F. G. Sarmenta 950409.2203
 *
 */

module seqmoddiv( div, mod, modprime, done, clk, a, b, start );

   parameter width = 1;

   output [width-1:0] div, mod, modprime;
   output done;
   input clk;
   input  [width-1:0] a, b;
   input start;

   wire [width-1:0] div, mod, nxtmod, nxtdiv;

   regencs #(width) curdiv( div, clk, nxtdiv, 1'b1, start, 1'b0 );
   muxreg #(width) curmod( mod, clk, nxtmod, a, start );
   moddiv #(width) compute( nxtdiv, nxtmod, modprime, done, mod, b, div );

endmodule


