/* seqmod.v
 *
 * sequential mod module
 *
 * This module computes:
 *        mod = (a mod b)
 *
 * Luis F. G. Sarmenta 950409.2344
 *
 */

module seqmod( modout, done, clk, a, b, start );

   parameter width = 1;

   output [width-1:0] modout;
   output done;
   input clk;
   input  [width-1:0] a, b;
   input start;

   wire [width-1:0] mod, modprime, nxtmod;

   seqmoddiv #(width) smd( , mod, modprime, done, clk, a, b, start );
   mux1of2 #(width) outmux( modout, mod, modprime, a[width-1] );

endmodule


