/* schdgst.v
 *
 * Scheduling hardware for generalized scheduling, slower transmitter
 *  ( assumes M < N, and cnt is the M counter )
 *
 * Luis F. G. Sarmenta 950408.0400
 *
 */

module schdgst( TE, TSel, clk, cnt, M, negDMN, e0M, y0, emax, SB );

   parameter width = 1;

   output TE, TSel;
   input  clk;
   input [width-1:0] M, negDMN, cnt, e0M, y0, emax;
   input  SB;

   wire preTE;
   wire ld;
   wire [width-1:0] y0_1;
   wire [width-1:0] negM, e;

   assign preTE = 1'b1;
   assign y0_1 = y0 - 1;

   assign negM = -M;

   ldgen #(width) ldgenN( ld, cnt, y0_1, M );

   egendb #(width) egenN( , e, clk, ld, negDMN, negM, e0M, 1'b1 );
   rgengbst #(width) rgenN( TSel, clk, preTE, ld, e, emax );

   nand nand1( noregs, SB, TSel );
   and  and1( TE, preTE, noregs );

endmodule


      