/* schdgsr.v
 *
 * Scheduling hardware for generalized scheduling, slower receiver
 *  ( assumes M < N, and cnt is the M counter )
 *
 * Luis F. G. Sarmenta 950408.0429
 *
 */

module schdgsr( RE, RSel, clk, cnt, M, negDMN, adje0M, y0, emin, SB );

   parameter width = 1;

   output RE, RSel;
   input  clk;
   input [width-1:0] M, negDMN, cnt, adje0M, y0, emin;
   input  SB;

   wire preRE;
   wire ld;
   wire [width-1:0] y0_1;
   wire [width-1:0] negM, e;

   assign preRE = 1'b1;
   assign y0_1 = y0 - 1;

   assign negM = -M;

   ldgen #(width) ldgenN( ld, cnt, y0_1, M );

   egendbg #(width) egenM( , e, clk, ld, negDMN, negM, adje0M, 1'b1 );
   rgengbsr #(width) rgenM( RSel, clk, preRE, ld, e, emin );

   nand nand1( noregs, SB, RSel );
   and  and1( RE, preRE, noregs );

endmodule


      