/* schdgft.v
 *
 * Scheduling hardware for generalized scheduling, faster transmitter
 *  ( assumes M < N, and cnt is the N counter )
 *
 * Luis F. G. Sarmenta 950408.0420
 *
 */

module schdgft( TE, TSel, clk, cnt, M, N, adje0, x0, emin, SB );

   parameter width = 1;

   output TE, TSel;
   input  clk;
   input [width-1:0] M, N, cnt, adje0, x0, emin;
   input  SB;

   wire ld;
   wire [width-1:0] x0_2;
   wire preTE;
   wire [width-1:0] e;

   assign x0_2 = x0 - 2;

   ldgen #(width) ldgenN( ld, cnt, x0_2, N );

   egendbg  #(width) egenN( preTE, e, clk, ld, M, N, adje0, 1'b0 );
   rgengbsr #(width) rgenN( TSel, clk, preTE, ld, e, emin );

   nand nand1( noregs, SB, TSel );
   and  and1( TE, preTE, noregs );

endmodule


      