/* schdgfr.v
 *
 * Scheduling hardware for generalized scheduling, faster receiver 
 *  ( assumes M < N, and cnt is the N counter )
 *
 * Luis F. G. Sarmenta 950408.0400
 *
 */

module schdgfr( RE, RSel, clk, cnt, M, N, e0, x0, emax, SB );

   parameter width = 1;

   output RE, RSel;
   input  clk;
   input [width-1:0] M, N, cnt, e0, x0, emax;
   input  SB;

   wire ld;
   wire [width-1:0] x0_1;
   wire preRE;
   wire [width-1:0] e;

   assign x0_1 = x0 - 1;

   ldgen #(width) ldgenN( ld, cnt, x0_1, N );

   egendb #(width) egenN( preRE, e, clk, ld, M, N, e0, 1'b0 );
   rgengbst #(width) rgenN( RSel, clk, preRE, ld, e, emax );

   nand nand1( noregs, SB, RSel );
   and  and1( RE, preRE, noregs );

endmodule


      