/* schdbstl.v
 *
 * Scheduling hardware for double-buffering, slower transmitter, lazy algo
 *  ( assumes M < N, and cnt is the M counter )
 *
 * Luis F. G. Sarmenta 950406.0013
 *
 */

module schdbstl( TE, TSel, clk, cnt, M, N, e0, y0 );

   parameter width = 1;

   output TE, TSel;
   input  clk;
   input [width-1:0] M, N, cnt, e0, y0;

   wire TE;
   wire ld;
   wire [width-1:0] y0_1;

   assign TE = 1'b1;
   assign y0_1 = y0 - 1;

   ldgen #(width) ldgenM( ld, cnt, y0_1, M );
   rgendb rgenM( TSel, clk, TE, ld );

endmodule


      