/* schdbstg.v
 *
 * Scheduling hardware for double-buffering, slower transmitter, greedy algo
 *  ( assumes M < N, and cnt is the M counter )
 *
 *
 * Luis F. G. Sarmenta 950408.0116
 *
 */

module schdbstg( TE, TSel, clk, cnt, M, N, e0, y0 );

   parameter width = 1;

   output TE, TSel;
   input  clk;
   input [width-1:0] M, N, cnt, e0, y0;

   schdbstl #(width) sch ( TE, TSel, clk, cnt, M, N, e0, y0 );

endmodule


      