/* schdbftg.v
 *
 * Scheduling hardware for double-buffering, faster transmitter, greedy algo
 *  ( assumes M < N, and cnt is the N counter )
 *
 * Luis F. G. Sarmenta 950406.0621
 *
 */

module schdbftg( TE, TSel, clk, cnt, M, N, adje0, x0 );

   parameter width = 1;

   output TE, TSel;
   input  clk;
   input [width-1:0] M, N, cnt, adje0, x0;

   wire ld;
   wire [width-1:0] x0_2;

   assign x0_2 = x0 - 2;

   ldgen #(width) ldgenN( ld, cnt, x0_2, N );
   egendbg #(width) egenN( TE, , clk, ld, M, N, adje0, 1'b0 );
   rgendb rgenN( TSel, clk, TE, ld );

endmodule


      