/* schdbfrl.v
 *
 * Scheduling hardware for double-buffering, faster receiver, lazy algo
 *  ( assumes M < N, and cnt is the N counter )
 *
 * Luis F. G. Sarmenta 950405.2359
 *
 */

module schdbfrl( RE, RSel, clk, cnt, M, N, e0, x0 );

   parameter width = 1;

   output RE, RSel;
   input  clk;
   input [width-1:0] M, N, cnt, e0, x0;

   wire ld;
   wire [width-1:0] x0_1;

   assign x0_1 = x0 - 1;

   ldgen #(width) ldgenN( ld, cnt, x0_1, N );
   egendb #(width) egenN( RE, , clk, ld, M, N, e0, 1'b0 );
   rgendb rgenN( RSel, clk, RE, ld );

endmodule


      