/* rxregN.v
 *
 * Receive Register with Enable and specifiable S and H times
 * <<< For System N >>>
 *
 * Note: S and H times are specified by modifying params.vh
 *
 * Luis F. G. Sarmenta 950514.2208
 *
 */

module rxregN( q, clk, d, en );

   parameter width = 1;

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en;

   reg [width-1:0] q;
   wire [width-1:0] q1;
   reg  flag;

`include "params.vh"

   specify
      specparam S = (`SN*100), H = (`HN*100);

      $setuphold( posedge clk &&& en, d, S, H, flag );
   endspecify

   always @(posedge clk)
   begin
      if (en)
         q = d;
   end

   always @(flag) q = q + 1'bx;


endmodule


