/* rxregM.v
 *
 * Receive Register with Enable and specifiable S and H times
 * <<< For System M >>>
 *
 * Note: S and H times are specified by modifying params.vh
 *
 * Luis F. G. Sarmenta 950514.2208
 *
 */

module rxregM( q, clk, d, en );

   parameter width = 1;

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en;

   reg [width-1:0] q;
   wire [width-1:0] q1;
   reg  flag;

`include "params.vh"

   specify
      specparam S = (`SM*100), H = (`HM*100);

      $setuphold( posedge clk &&& en, d, S, H, flag );
   endspecify

   always @(posedge clk)
   begin
      if (en)
         q = d;
   end

   always @(flag) q = q + 1'bx;


endmodule


