/* rxreg.v
 *
 * Receive Register with Enable and specifiable S and H times
 *
 * This register simulates a transition window by delaying  the LSB by P 
 * and all the other bits by C.  
 *
 * Luis F. G. Sarmenta 950514.2208
 *
 */

module rxreg( q, clk, d, en );

   parameter width = 1;
/*   parameter C = 0;
     parameter P = 0;
*/

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en;

   reg [width-1:0] q;
   wire [width-1:0] q1;
   reg  flag;


   specify
      specparam S = 100, H = 100;

      $setuphold( posedge clk &&& en, d, S, H, flag );
   endspecify

   always @(posedge clk)
   begin
      if (en)
         q = d;
   end

   always @(flag) q = q + 1'bx;


endmodule


