/* rgengbst.v
 *
 * The RGen module for generalized scheduling, slower transmitter case
 *
 * Luis F. G. Sarmenta 950408.0322
 *
 */

module rgengbst( r, clk, en, ld, e, emax );

   parameter width = 1;

   output r;
   input clk;
   input en, ld;
   input [width-1:0] e, emax;

   wire le, d;

   leq #(width) eleqemax( le, e, emax );
   nor nr1( d, le, r );
   regencs rreg( r, clk, d, en, ld, 1'b0 );

endmodule


