/* rgengbsr.v
 *
 * The RGen module for generalized run-time scheduling, slower receiver case
 *
 * Luis F. G. Sarmenta 950408.0322
 *
 */

module rgengbsr( r, clk, en, ld, e, emin );

   parameter width = 1;

   output r;
   input clk;
   input en, ld;
   input [width-1:0] e, emin;

   wire ge, q;

   leq #(width) egeqemin( ge, emin, e );
   nor nr1( r, ge, q );
   regencs rreg( q, clk, r, en, 1'b0, ld );

endmodule


