/* regencs.v
 *
 * Register with Enable and Synchronous Clear and Set
 * (Clr overrides Set)
 *
 * Luis F. G. Sarmenta 950404.1914
 *
 */

module regencs( q, clk, d, en, clr, set );

   parameter width = 1;

   output [width-1:0] q;
   input clk;
   input [width-1:0] d;
   input en, clr, set;

   reg [width-1:0] q;

   always @(posedge clk)
   begin
      if (en)
         if (clr)
            q = 0;
         else 
            if (set)
               q = 1;
            else
               q = d;
   end

endmodule


