/* moddiv.v
 *
 * mod / div module
 *
 * This module computes:
 *     if a >= 0
 *        mod = (a mod b)
 *        div = (a div b)
 *     if a < 0 
 *        mod = (a mod b) - b
 *        mod' = (a mod b)
 *        div = -(a div b)         if (a mod b != 0)
 *            = -(a div b) - 1     if (a mod b == 0)
 *
 * This module can be cascaded by connecting mod to a and div to divin.
 * sgnchg would then indicate when the operation is done.
 *
 * Luis F. G. Sarmenta 950409.2203
 *
 */

module moddiv( div, mod, modprime, sgnchg, a, b, divin );

   parameter width = 1;

   output [width-1:0] div, mod, modprime;
   output sgnchg;
   input  [width-1:0] a, b, divin;

   wire [width-1:0] div, mod, modprime;
   wire sgna, nsgna, sgnchg;

   assign sgna = a[width-1];
   assign nsgna = ~sgna;

   addsub #(width) add1( modprime, a, b, nsgna );
   xor x1( sgnchg, modprime[width-1], sgna );
   mux1of2 #(width) modmux( mod, modprime, a, sgnchg );
   incinh  #(width) divinc( div, divin, sgnchg );

endmodule


