/* leq.v
 *
 * Less-than-or-equal-to comparator
 *   ( checks if a <= b )
 *
 * Note that this version assumes Verilog treats the numbers as
 * unsigned numbers and does its own signed version of leq.
 *
 * Luis F. G. Sarmenta 950409.2128
 *
 */

module leq( res, a, b );

   parameter width = 1;

   output res;
   input  [width-1:0] a, b;

   assign res = ( a[width-1]  
                  ? ( b[width-1] 
                        ? ( a >= b ) 
                        : 1
                    )
                  : ( !b[width-1] 
                        ? ( a <= b )
                        : 0
                    )
                );

endmodule


