/* ldgen.v
 *
 * LD Gen module 
 *   (checks if count == (i-1) mod M and generates LD signal)
 *
 * Luis F. G. Sarmenta 950405.2256
 *
 */

module ldgen( ld, count, i, M );

   parameter width = 1;

   output ld;
   input  [width-1:0] count, i, M;

/* The following hack is totally weird! The % operator works really
   weirdly.  I got this fix by trial and error.  Fix this later by 
   using real mod hardware.

   wire   [width:0] iM;
   wire   [width-1:0] iMo;

   assign iM = ( {i[width-1],i} - 1 + M);
   assign iMo = iM % M;
*/

   wire   [width-1:0] i_1, a1, iMo;

   assign a1 = 1;

   addsub #(width) sub1( i_1, i, a1, 1'b1 );
   commod #(width) domod( iMo, i_1, M );

   assign ld = ( count == iMo );

endmodule


