/* gbftsr.v
 *
 * Controller for generalized scheduling, slower receiver case (greedy algo)
 *  ( assumes M < N )
 *  This is just a test case, and should be changed later.
 *
 * Luis F. G. Sarmenta 950417.1006
 *
 */

module gbftsr( zM, cntM, REM, RSelM, zN, cntN, TEN, TSelN, 
              clkS, clkM, clkN, clr, 
              M, N, CM, PM, SM, HM, CN, PN, SN, HN,
              SB );

   parameter width = 5;

   output zM, REM, RSelM, zN, TEN, TSelN;
   output  [width-1:0] cntM, cntN;
   input  clkS, clkM, clkN, clr;
   input [width-1:0] M, N, CM, PM, SM, HM, CN, PN, SN, HN;
   input SB;

   wire [width-1:0] f0, e0, adje0, x0, y0, adjy0;
   wire [width-1:0] DMN, negDMN, e0M, adje0M, emin;
   wire [width-1:0] divsr, modsr;
   wire donee0M, doneDMN;

   seqmod #(width) cDMN( DMN, doneDMN, clkS, N, M, clr );
   neg    #(width) cnDMN( negDMN, DMN );

   assign x0 = 1;
   assign f0 = SM+PN;

   commoddiv #(width) compe0y0sr( divsr, modsr, , f0, N );
   forme0    #(width) compe0sr( e0, modsr, N, f0[width-1] );
   adjuste0  #(width) adjuste0( adje0, e0, N );   

   formy0    #(width) compy0sr( y0, divsr, f0[width-1] );
   assign    adjy0 = (adje0 == 0) ? (y0-1) : y0;
   
   seqmod  #(width) ce0Msr( e0M, donee0M, clkS, adje0, M, clr ); 
   adjuste0M #(width) adjuste0M( adje0M, e0M, M );

   assign emin = M + ((PN-CN) + (SM+HM)) - N;


   fdiv  #(width) fdivM( zM, cntM, clkM, M, 1'b0, clr );
   fdiv  #(width) fdivN( zN, cntN, clkN, N, 1'b0, clr );

   schdgsr #(width) schM( REM, RSelM, clkM, cntM, 
                          M, negDMN, adje0M, adjy0, emin, SB );
   schdgft #(width) schN( TEN, TSelN, clkN, cntN, 
                          M, N, adje0, x0, emin, SB );

endmodule


      