/* fdiv.v
 *
 * Frequency divider, divides by M
 *
 * (Note: fdiv currently doesn't work for M = 1)
 *
 * Luis F. G. Sarmenta 950405.2356
 *
 * ( 950406.0147  I have removed the AND function temporarily since
 *   it produces a glitch in clkout one cycle after hte intended pulse
 *   because z changes _after_ clkin. )
 *  ( This is similar to countup, but automatically feeds M-1, and
 *    also ANDs z with clkin so that it works even if M == 1 )
 *
 */

module fdiv( clkout, q, clkin, M, clr, set );

   parameter width = 1;

   output clkout;
   output [width-1:0] q;
   input clkin;
   input [width-1:0] M;
   input clr, set;

   wire z;
   wire [width-1:0] tc;

   wire  clkout;

   assign tc = M-1;

   countup #(width) cnt ( z, q, clkin, tc, clr, set );

   assign clkout = z;

/* Note: The following lines can be used to avoid glitches in 
   clkout at posedge clkin when z = 0.  However, they are not realistic.

   always @(posedge z)
   begin
      clkout = z & clkin;
   end

   always @(negedge clkin)
   begin
      clkout = z & clkin;
   end

*/

endmodule


      