/* egendbg.v
 *
 * The EGen module for double-buffering greedy slower receiver algo
 *
 * Luis F. G. Sarmenta 950408.0348
 *
 */

module egendbg( E, eout, clk, ld, M, N, e0, gb );

   parameter width = 1;

   output E;
   output [width-1:0] eout;
   input clk;
   input ld;
   input [width-1:0] M, N, e0;
   input gb;

   wire E, notE;
   wire [width-1:0] eout, negN, eold, e, eN, nxteold;
   wire sgne, z;
   wire muxsel;

   assign negN = -N;

   muxreg #(width) eoldreg( eold, clk, nxteold, e0, ld );
   adder  #(width) eoplusM( e, eold, M, 1'b0 );
   adder #(width)  esubN( eN, e, negN, 1'b0 );
   zero   #(width) ez( z, e );

   assign sgne = e[width-1];

   nor    gtz( E, z, sgne );
   assign notE = ~E;

   xor x1( muxsel, notE, gb );
   mux1of2 #(width) neomux( nxteold, eN, e, muxsel );

   mux1of2 #(width) eoutmux( eout, e, eold, gb );

endmodule


