/* egendb.v
 *
 * The EGen module, slower transmitter case
 *
 * Luis F. G. Sarmenta 950409.2039
 *
 * This module works as the EGen module for double-buffering when gb is 0, 
 * and works as the modified EGen module in the slower system's 
 * generalized schedling hardware for the slower transmitter case.
 *
 */

module egendb( E, eout, clk, ld, M, N, e0, gb );

   parameter width = 1;

   output E;
   output [width-1:0] eout;
   input clk;
   input ld;
   input [width-1:0] M, N, e0;
   input gb;

   wire E;
   wire [width-1:0] eout, negN, eold, e, eN, nxteold;
   wire sgne;
   wire muxsel;

   assign negN = -N;

   muxreg #(width) eoldreg( eold, clk, nxteold, e0, ld );
   adder  #(width) eoplusM( e, eold, M, 1'b0 );
   adder #(width) esubN( eN, e, negN, 1'b0 );

   assign sgne = e[width-1];
   assign E = ~sgne;

   xor x1( muxsel, sgne, gb );
   mux1of2 #(width) neomux( nxteold, eN, e, muxsel );

   mux1of2 #(width) eoutmux( eout, e, eold, gb );

endmodule



