/* driver.v
 *
 * Driver / Test Module 
 *
 * Luis F. G. Sarmenta 950514
 *
 */

/* Define the algorithm/hardware to use */

`define GENB


/* Define which wave forms to view */

`define VIEW_M_TO_N


module driver;

   parameter width = 5;

   reg clkhi, clr;
   wire clkM, clkN;
   wire [width-1:0] cntM, cntN, dM, dN, qM, qN, qinM, qinN;

   wire TEM,TSelM,REN,RSelN,TEN,TSelN,REM,RSelM;

   wire validN, validM;
   wire dlyREM, dlyREN, dlyRSelM, dlyRSelN;

`include "params.vh"

   parameter SB = 1'b0;

   parameter M = `M;
   parameter N = `N;

   parameter CM = `CM;
   parameter PM = `PM;
   parameter SM = `SM;
   parameter HM = `HM;

   parameter CN = `CN;
   parameter PN = `PN;
   parameter SN = `SN;
   parameter HN = `HN;


/*
 * Clock Generation (Clock Division) Counters 
 *
 */

   fdiv #(width) genclkM( clkM, , clkhi, N, 1'b0, clr );
   fdiv #(width) genclkN( clkN, , clkhi, M, 1'b0, clr );

/*
 * Scheduling Hardware
 *
 */

`ifdef NOCNTL				/* No flow control */
   /* Index Counters (the other hardware options have built-in 
      index counters) */
   fdiv  #(width) fdivM( zM, cntM, clkM, M, 1'b0, clr );
   fdiv  #(width) fdivN( zN, cntN, clkN, N, 1'b0, clr );

   assign TEM = 1'b1;
   assign TSelM = 1'b1;
   assign REN = 1'b1;
   assign RSelN = 1'b1;
   assign TEN = 1'b1;
   assign TSelN = 1'b1;
   assign REM = 1'b1;
   assign RSelM = 1'b1;
`endif

`ifdef DBLAZY				/* Double-buffered Lazy */
   dbstfrl #(width) stfr( zM, cntM, TEM, TSelM, zN, cntN, REN, RSelN, 
                           /* clkhi, */ clkM, clkN, clr, M, N,
                           CM, PM, SM, HM, CN, PN, SN, HN 
                           /* SB */ );

   dbftsrl #(width) ftsr( , , REM, RSelM, , , TEN, TSelN, 
                           /* clkhi, */ clkM, clkN, clr, M, N, 
                           CM, PM, SM, HM, CN, PN, SN, HN 
                           /* SB */ );
`endif

`ifdef DBGREEDY				/* Double-buffered Greedy */
   dbstfrg #(width) stfr( zM, cntM, TEM, TSelM, zN, cntN, REN, RSelN, 
                           /* clkhi, */ clkM, clkN, clr, M, N,
                           CM, PM, SM, HM, CN, PN, SN, HN 
                           /* SB */ );

   dbftsrg #(width) ftsr( , , REM, RSelM, , , TEN, TSelN, 
                           /* clkhi, */ clkM, clkN, clr, M, N, 
                           CM, PM, SM, HM, CN, PN, SN, HN 
                           /* SB */ );
`endif

`ifdef GENB				/* Generalized Scheduling */
   gbstfr #(width) stfr( zM, cntM, TEM, TSelM, zN, cntN, REN, RSelN, 
                           clkhi, clkM, clkN, clr, M, N,
                           CM, PM, SM, HM, CN, PN, SN, HN, 
                           SB );

   gbftsr #(width) ftsr( , , REM, RSelM, , , TEN, TSelN, 
                           clkhi, clkM, clkN, clr, M, N, 
                           CM, PM, SM, HM, CN, PN, SN, HN,
                           SB );
`endif


/* 
 * Data Channels
 *
 */

	/* M to N */

   counten #(width) dataM( , dM, clkM, TEM, clr );

   /* Note: Here we delay RSel by the receiver's C delay to prevent RSel 
    * from causing a hold time violation.  */

   assign #(CN*100) dlyRSelN = RSelN;
   assign #(CN*100) dlyREN = REN;
   dbout   #(width,CM*100,PM*100) outM( qM, clkM, dM, TEM, TSelM, dlyRSelN );

   rxregN   #(width) inN( qinN, clkN, qM, dlyREN );
   regen   vN( validN, clkN, REN, 1'b1 );

	/* N to M */

   counten #(width) dataN( , dN, clkN, TEN, clr );

   assign #(CM*100) dlyRSelM = RSelM;
   assign #(CM*100) dlyREM = REM;
   dbout   #(width,CN*100,PN*100) outN( qN, clkN, dN, TEN, TSelN, dlyRSelM );

   rxregM   #(width) inM( qinM, clkM, qN, dlyREM );
   regen   vM( validM, clkM, REM, 1'b1 );


/*
 * Clkhi and Reset Generators
 *
 */

	/* clock period = 100 */

   initial
      forever
      begin
	 clkhi = 1;
         #50;
         clkhi = 0;
         #50;
      end

   	/* reset on start */

   initial
      begin
         clr = 0 ;
         #150;
         clr = 1 ;
         #100;
         clr = 0 ;
      end

/*
 * Display Routines
 *
 */

/*  Primitive text output for non-graphics terminals

         always @( cntM )
            $strobe( "cM=%d, %b%b %b%b", cntM[width-1:0], 
                     TEM, TSelM, REM, RSelM );

         always @( cntN )
            $strobe( "\t\tcN=%d, %b%b %b%b", cntN[width-1:0], 
                     REN, RSelN, TEN, TSelN,  );
*/

/* Graphical Output */

   initial
      begin
         $gr_waves( 
/*                   "clr", clr,
                   "clkhi", clkhi,

                   "clkN", clkN,
                   "clkM", clkM,
                   "zN", zN,
                   "zM", zM,   

                   "divst", divst,
                   "modst", modst,
                   "modpst", modpst,
                   "e0st", e0st,
                   "e0Mst", e0Mst,
                   "y0st", y0st,
                   "e0sr", e0sr,
                   "e0Msr", e0Msr,
                   "y0sr", y0sr,
                   "emax", emax,
                   "emin", emin,
*/
`ifdef VIEW_M_TO_N
                   "cntN", cntN[width-1:0],
                   "qinN", qinN[width-1:0],
                   "validN", validN,
                   "REN'", dlyREN,
                   "RSelN'", dlyRSelN,

                   "qM", qM[width-1:0],
                   "q0M", outM.q0[width-1:0],
                   "q1M", outM.q1[width-1:0],
                   "TSelM", TSelM,
                   "TEM", TEM,
                   "dM", dM[width-1:0],
                   "cntM", cntM[width-1:0]
`endif
`ifdef VIEW_N_TO_M
                   "cntN", cntN[width-1:0],
                   "dN", dN[width-1:0],
                   "TEN", TEN,
                   "TSelN", TSelN,
                   "q0N", outN.q0[width-1:0],
                   "q1N", outN.q1[width-1:0],
                   "qN", qN[width-1:0],

                   "RSelM'", dlyRSelM,
                   "REM'", dlyREM,
                   "validM", validM,
                   "qinM", qinM[width-1:0],
                   "cntM", cntM[width-1:0]
`endif
                 );

      end

endmodule







