/* dbout.v
 *
 * Double-bufferd output hardware
 *
 * This module contains two transmit registers a selecting demux.
 * It takes the transmitter's C and P delays as parameters 
 * and passes them to txreg.
 *  
 *
 * Luis F. G. Sarmenta 950514.2212
 *
 */

module dbout( q, clk, d, TE, TSel, RSel );

   parameter width = 1;
   parameter C = 0;
   parameter P = 0;

   output [width-1:0] q;
   input  clk;
   input [width-1:0] d;
   input TE, TSel, RSel;

   wire en0, en1;
   wire [width-1:0] q0, q1;
   wire dlyRSel;

   txreg #(width,C,P) r0( q0, clk, d, en0 );
   txreg #(width,C,P) r1( q1, clk, d, en1 );
   demux1to2 seldemux( en0, en1, TE, TSel );

   mux1of2 #(width) qmux( q, q0, q1, RSel );


endmodule


      