/* dbftsrl.v
 *
 * Controller for double-buffering, slower receiver case (lazy algo)
 *  ( assumes M < N )
 *  This is just a test case, and should be changed later.
 *
 * Luis F. G. Sarmenta 950417.2055
 *
 */

module dbftsrl( zM, cntM, REM, RSelM, zN, cntN, TEN, TSelN, 
                  clkM, clkN, clr, 
                  M, N, CM, PM, SM, HM, CN, PN, SN, HN );

   parameter width = 5;

   output zM, REM, RSelM, zN, TEN, TSelN;
   output [width-1:0] cntM, cntN;
   input  clkM, clkN, clr;
   input [width-1:0] M, N, CM, PM, SM, HM, CN, PN, SN, HN;

   wire [width-1:0] f0, e0, x0, y0;
   wire [width-1:0] divst, modst;

   assign x0 = 1;
   assign f0 = CN-HM;

   commoddiv #(width) compe0y0st( divst, modst, , f0, N );
   forme0    #(width) compe0st( e0, modst, N, f0[width-1] ); 
   formy0    #(width) compy0st( y0, divst, f0[width-1] );

   fdiv  #(width) fdivM( zM, cntM, clkM, M, 1'b0, clr );
   fdiv  #(width) fdivN( zN, cntN, clkN, N, 1'b0, clr );

   schdbsrl #(width) schM( REM, RSelM, clkM, cntM, M, N, e0, y0 );
   schdbftl #(width) schN( TEN, TSelN, clkN, cntN, M, N, e0, x0 );

endmodule


      