/* dbftsrg.v
 *
 * Controller for double-buffering, slower receiver case (greedy algo)
 *  ( assumes M < N )
 *  This is just a test case, and should be changed later.
 *
 * Luis F. G. Sarmenta 950417.2055
 *
 */

module dbftsrg( zM, cntM, REM, RSelM, zN, cntN, TEN, TSelN, 
                  clkM, clkN, clr, 
                  M, N, CM, PM, SM, HM, CN, PN, SN, HN );

   parameter width = 5;

   output zM, REM, RSelM, zN, TEN, TSelN;
   output [width-1:0] cntM, cntN;
   input  clkM, clkN, clr;
   input [width-1:0] M, N, CM, PM, SM, HM, CN, PN, SN, HN;

   wire [width-1:0] f0, e0, adje0, x0, y0, adjy0;
   wire [width-1:0] divsr, modsr;

   assign x0 = 1;
   assign f0 = SM+PN;

   commoddiv #(width) compe0y0sr( divsr, modsr, , f0, N );
   forme0    #(width) compe0sr( e0, modsr, N, f0[width-1] );
   adjuste0  #(width) adjuste0( adje0, e0, N );   

   formy0    #(width) compy0sr( y0, divsr, f0[width-1] );
   assign    adjy0 = (adje0 == 0) ? (y0-1) : y0;

   fdiv  #(width) fdivM( zM, cntM, clkM, M, 1'b0, clr );
   fdiv  #(width) fdivN( zN, cntN, clkN, N, 1'b0, clr );

   schdbsrg #(width) schM( REM, RSelM, clkM, cntM, M, N, adje0, adjy0 );
   schdbftg #(width) schN( TEN, TSelN, clkN, cntN, M, N, adje0, x0 );

endmodule


      