/* countup.v
 *
 * countup timer with terminal count (tc), Asynchronous clear and set (to tc)
 *
 * Luis F. G. Sarmenta 950404.1942
 *
 */

module countup( z, q, clk, tc, clr, set );

   parameter width = 1;

   output z;
   output [width-1:0] q;
   input clk;
   input [width-1:0] tc;
   input clr, set;

   reg [width-1:0] q;

   assign z = (q == 0);

   always @(clr or set)
      if (clr)
         q = 0;
      else
         if (set)
            q = tc;

   always @(posedge clk)
      if (clr)
         q = 0;
      else
         if (set)
            q = tc;
         else
            q = (q == tc) ? 0 : (q + 1);

endmodule


      