/* commoddiv.v
 *
 * combinational mod / div module -- cascaded twice
 *
 * (see moddiv.v for more details)
 *
 * Luis F. G. Sarmenta 950410.1221
 *
 */

module commoddiv( div, mod, modprime, a, b );

   parameter width = 1;

   output [width-1:0] div, mod, modprime;
   input  [width-1:0] a, b;

   wire [width-1:0] nxtmod, nxtdiv, div0;

   assign div0 = 0;

   moddiv #(width) m1( nxtdiv, nxtmod, , , a, b, div0 );
   moddiv #(width) m2( div, mod, modprime, , nxtmod, b, nxtdiv );

endmodule


