/* commod.v
 *
 * combinational mod module
 *
 * This module computes:
 *        mod = (a mod b) for  -3b < a < 3b
 *
 * Luis F. G. Sarmenta 950410.1834
 *
 */

module commod( modout, a, b );

   parameter width = 1;

   output [width-1:0] modout;
   input  [width-1:0] a, b;

   wire [width-1:0] mod, modprime;

   commoddiv #(width) cmd( , mod, modprime, a, b );
   mux1of2 #(width) outmux( modout, mod, modprime, a[width-1] );

endmodule


